/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbc;

import com.mckoi.database.global.ByteLongObject;
import com.mckoi.database.global.ObjectTransfer;
import com.mckoi.database.global.ObjectTranslator;
import com.mckoi.database.jdbc.MSQLException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;

public final class SQLQuery {
    private String query;
    private boolean prepared;
    private Object[] parameters;
    private int parameters_index;
    private int parameter_count;

    private SQLQuery() {
    }

    public SQLQuery(String query) {
        this.query = query;
        this.parameters = new Object[8];
        this.parameters_index = 0;
        this.parameter_count = 0;
        this.prepared = false;
    }

    private void growParametersList(int new_size) {
        Object[] new_list = new Object[new_size];
        System.arraycopy(this.parameters, 0, new_list, 0, this.parameters.length);
        this.parameters = new_list;
    }

    private Object translateObjectType(Object ob) {
        return ObjectTranslator.translate(ob);
    }

    public void addVar(Object ob) {
        this.parameters[this.parameters_index] = ob = this.translateObjectType(ob);
        ++this.parameters_index;
        ++this.parameter_count;
        if (this.parameters_index >= this.parameters.length) {
            this.growParametersList(this.parameters_index + 8);
        }
    }

    public void setVar(int i, Object ob) {
        ob = this.translateObjectType(ob);
        if (i >= this.parameters.length) {
            this.growParametersList(i + 8);
        }
        this.parameters[i] = ob;
        this.parameters_index = i + 1;
        this.parameter_count = Math.max(this.parameters_index, this.parameter_count);
    }

    public void clear() {
        this.parameters_index = 0;
        this.parameter_count = 0;
        for (int i = 0; i < this.parameters.length; ++i) {
            this.parameters[i] = null;
        }
    }

    public String getQuery() {
        return this.query;
    }

    public Object[] getVars() {
        return this.parameters;
    }

    private String escapeJDBCSubstitution(String jdbc_code) throws SQLException {
        String code = jdbc_code.substring(1, jdbc_code.length() - 1);
        int kp_delim = code.indexOf(32);
        if (kp_delim != -1) {
            String keyword = code.substring(0, kp_delim);
            String body = code.substring(kp_delim).trim();
            if (keyword.equals("d")) {
                return "DATE " + body;
            }
            if (keyword.equals("t")) {
                return "TIME " + body;
            }
            if (keyword.equals("ts")) {
                return "TIMESTAMP " + body;
            }
            if (keyword.equals("fn")) {
                return body;
            }
            if (keyword.equals("call") || keyword.equals("?=")) {
                throw new MSQLException("Stored procedures not supported.");
            }
            if (keyword.equals("oj")) {
                return body;
            }
            throw new MSQLException("Do not understand JDBC substitution keyword '" + keyword + "' of " + jdbc_code);
        }
        throw new MSQLException("Malformed JDBC escape code: " + jdbc_code);
    }

    private void doEscapeSubstitutions() throws SQLException {
        if (this.query.indexOf(123) == -1) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        StringBuffer jdbc_escape = null;
        int sz = this.query.length();
        int state = 0;
        boolean ignore_next = false;
        for (int i = 0; i < sz; ++i) {
            char c = this.query.charAt(i);
            if (state == 0) {
                if (c == '\'' || c == '\"') {
                    state = c;
                } else if (c == '{') {
                    jdbc_escape = new StringBuffer();
                    state = 125;
                }
            } else if (state != 0) {
                if (!ignore_next) {
                    if (c == '\\') {
                        ignore_next = true;
                    } else if (c == (char)state) {
                        state = 0;
                        if (c == '}') {
                            jdbc_escape.append('}');
                            buf.append(this.escapeJDBCSubstitution(new String(jdbc_escape)));
                            jdbc_escape = null;
                            c = ' ';
                        }
                    }
                } else {
                    ignore_next = false;
                }
            }
            if (state != 125) {
                buf.append(c);
                continue;
            }
            jdbc_escape.append(c);
        }
        if (state == 125) {
            throw new SQLException("Unterminated JDBC escape code in query: " + new String(jdbc_escape));
        }
        this.query = new String(buf);
    }

    public void prepare(boolean do_escape_processing) throws SQLException {
        if (do_escape_processing) {
            this.doEscapeSubstitutions();
        }
        this.prepared = true;
    }

    public boolean equals(Object ob) {
        SQLQuery q2 = (SQLQuery)ob;
        if (this.query.equals(q2.query) && this.parameter_count == q2.parameter_count) {
            for (int i = 0; i < this.parameter_count; ++i) {
                if (this.parameters[i] == q2.parameters[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public SQLQuery copy() {
        SQLQuery q = new SQLQuery();
        q.query = this.query;
        q.parameters = (Object[])this.parameters.clone();
        q.parameters_index = this.parameters_index;
        q.parameter_count = this.parameter_count;
        q.prepared = this.prepared;
        return q;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[ Query:\n[ ");
        buf.append(this.getQuery());
        buf.append(" ]\n");
        if (this.parameter_count > 0) {
            buf.append("\nParams:\n[ ");
            for (int i = 0; i < this.parameter_count; ++i) {
                Object ob = this.parameters[i];
                if (ob == null) {
                    buf.append("NULL");
                } else {
                    buf.append(this.parameters[i].toString());
                }
                buf.append(", ");
            }
            buf.append(" ]");
        }
        buf.append("\n]");
        return new String(buf);
    }

    public void writeTo(DataOutputStream out) throws IOException {
        out.writeUTF(this.query);
        out.writeInt(this.parameter_count);
        for (int i = 0; i < this.parameter_count; ++i) {
            ObjectTransfer.writeTo(out, this.parameters[i]);
        }
    }

    public static SQLQuery readFrom(DataInputStream in) throws IOException {
        String query_string = in.readUTF();
        SQLQuery query = new SQLQuery(query_string);
        int arg_length = in.readInt();
        for (int i = 0; i < arg_length; ++i) {
            query.addVar(ObjectTransfer.readFrom(in));
        }
        return query;
    }

    public ByteLongObject serializeToBlob() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bout);
        try {
            this.writeTo(out);
            out.flush();
            return new ByteLongObject(bout.toByteArray());
        }
        catch (IOException e) {
            throw new Error("IO Error: " + e.getMessage());
        }
    }

    public static SQLQuery deserializeFromBlob(ByteLongObject ob) {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(ob.getByteArray()));
        try {
            return SQLQuery.readFrom(in);
        }
        catch (IOException e) {
            throw new Error("IO Error: " + e.getMessage());
        }
    }
}

